﻿using System;
using System.Net;
using System.Text.RegularExpressions;
using System.Xml;
using System.Xml.Linq;

namespace RssReader.BusinessLogic
{

    public delegate void RssItemLoadedEventHandler(object sender, RssItemEventArgs e);

    public class RssFeedReader
    {
        public event RssItemLoadedEventHandler RssItemLoaded;

        public void LoadRssFeed(string url)
        {
            var request = (HttpWebRequest)WebRequest.Create(new Uri(url));
            request.BeginGetResponse(new AsyncCallback(ResponseCallbackHandler), request);
        }


        private void ResponseCallbackHandler(IAsyncResult asyncResult)
        {
            var request = (HttpWebRequest)asyncResult.AsyncState;
            var response = (HttpWebResponse)request.EndGetResponse(asyncResult);

            if (response.StatusCode == HttpStatusCode.OK)
            {
                var reader = XmlReader.Create(response.GetResponseStream());

                var document = XDocument.Load(reader);

                foreach (XElement value in document.Elements().Elements("channel").Elements("item"))
                {
                    var item = new RssItem();
                    item.Title = value.Element("title").Value;
                    item.Description = Regex.Replace(value.Element("description").Value, @"<(.|\n)*?>", String.Empty);
                    item.Link = value.Element("link").Value;
                    item.ImageLink = value.Element("image").Value;
                    item.DatePublished = DateTime.Parse(value.Element("pubDate").Value);

                    if (RssItemLoaded != null)
                    {
                        RssItemLoaded(this, new RssItemEventArgs() { Item = item });
                    }
                }
            }
        }


    }
}
